/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.lib.effect.CustomEffect;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class BillboardingEffectRenderer {
    private static final Minecraft minecraft = Minecraft.m_91087_();

    private BillboardingEffectRenderer() {
    }

    public static void render(CustomEffect effect, BlockPos renderPos, PoseStack matrixStack, MultiBufferSource renderer, long time, float partialTick) {
        matrixStack.m_85836_();
        int gridSize = effect.getTextureGridSize();
        VertexConsumer buffer = BillboardingEffectRenderer.getRenderBuffer(renderer, effect.getTexture());
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        Camera renderInfo = BillboardingEffectRenderer.minecraft.f_91063_.m_109153_();
        int tick = (int)time % (gridSize * gridSize);
        int xIndex = tick % gridSize;
        int yIndex = tick / gridSize;
        float spriteSize = 1.0f / (float)gridSize;
        Quaternion quaternion = renderInfo.m_90591_();
        Vector3f[] vertexPos = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        Vec3 pos = effect.getPos(partialTick).m_82546_(Vec3.m_82528_((Vec3i)renderPos));
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vertexPos[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(effect.getScale());
            vector3f.m_122272_((float)pos.m_7096_(), (float)pos.m_7098_(), (float)pos.m_7094_());
        }
        int[] color = effect.getColor().rgbaArray();
        float minU = (float)xIndex * spriteSize;
        float maxU = minU + spriteSize;
        float minV = (float)yIndex * spriteSize;
        float maxV = minV + spriteSize;
        buffer.m_85982_(matrix, vertexPos[0].m_122239_(), vertexPos[0].m_122260_(), vertexPos[0].m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(minU, maxV).m_5752_();
        buffer.m_85982_(matrix, vertexPos[1].m_122239_(), vertexPos[1].m_122260_(), vertexPos[1].m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(maxU, maxV).m_5752_();
        buffer.m_85982_(matrix, vertexPos[2].m_122239_(), vertexPos[2].m_122260_(), vertexPos[2].m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(maxU, minV).m_5752_();
        buffer.m_85982_(matrix, vertexPos[3].m_122239_(), vertexPos[3].m_122260_(), vertexPos[3].m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(minU, minV).m_5752_();
        matrixStack.m_85849_();
    }

    protected static VertexConsumer getRenderBuffer(MultiBufferSource renderer, ResourceLocation texture) {
        return renderer.m_6299_(MekanismRenderType.SPS.apply(texture));
    }
}

